/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.ftb.log.LogLevel;
import net.ftb.log.Logger;

public class OutputOverride
extends PrintStream {
    final LogLevel level;

    public OutputOverride(OutputStream str, LogLevel type) {
        super(str);
        this.level = type;
    }

    @Override
    public void write(byte[] b) throws IOException {
        String text = new String(b).trim();
        if (!text.equals("") && !text.equals("\n")) {
            Logger.log("From Console: " + text, this.level, null);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        String text = new String(buf, off, len).trim();
        if (!text.equals("") && !text.equals("\n")) {
            Logger.log("From Console: " + text, this.level, null);
        }
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException("Write(int) is not supported by OutputOverride.");
    }
}

